--[NEW] This is how we tell the game we've created a new prefab.
PrefabFiles = {
	--[NEW] This is the name of our prefab file in scripts/prefabs
	"ghostplayer",
	"summonclone",
	"abigail_3",
	"books_player_3",
	"nightsword_player_3",
	"balloons_empty_player_3",
	"lighter_player_3",
	"axe_player_3",
	"camera_prefab",
	"deftorch",
	"deftorch2",	
}
local require = GLOBAL.require
local GetWorld = GLOBAL.GetWorld
local GetPlayer = GLOBAL.GetPlayer
local table = require("table")
local math = require("math")
local Point = GLOBAL.Point -- note: Point is an alias of Vector3
local distsq = GLOBAL.distsq
local TILE_SCALE = GLOBAL.TILE_SCALE
local TUNING = GLOBAL.TUNING
--------------------------------------------------------------------------

local FollowCamera = GLOBAL.require("cameras/followcamera")
local default = FollowCamera.SetDefault

FollowCamera.SetDefault = function (self)
	default(self)
    if self.headingtarget == nil then
        self.headingtarget = 45
    end

    self.fov = 35
    self.pangain = 4
    self.headinggain = 20
    self.distancegain = 1

    self.zoomstep = 4
    self.distancetarget = 30

    self.mindist = 25
    self.maxdist = 125 --40
   
    self.mindistpitch = 30
    self.maxdistpitch = 60--60 
    self.paused = false
    self.shake = nil
    self.controllable = true
    self.cutscene = false

end
--------------------------------------------------------------------------

local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local TUNING = GLOBAL.TUNING
local ACTIONS = GLOBAL.ACTIONS

-----NOTES

STRINGS.NAMES.SUMMONCLONE = " "
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUMMONCLONE = {}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUMMONCLONE.GENERIC = "Hello!"

STRINGS.NAMES.GHOSTPLAYER = " "
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GHOSTPLAYER = {}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GHOSTPLAYER.GENERIC = "Rise from your grave!"

STRINGS.NAMES.ABIGAIL_3 = "Abigail"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ABIGAIL_3 = {}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ABIGAIL_3.GENERIC = "Abigail, twin sister of Wendy!"


---------/////////// PLAYER 3 SPECIAL ITEMS///////////////---------
STRINGS.NAMES.BOOKPLAYER3 = "The End is Nigh!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BOOKPLAYER3 = {}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BOOKPLAYER3.GENERIC = "The world will end in fire and tribulation!"


STRINGS.NAMES.AXE_PLAYER_3 = "Lucy the Axe"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AXE_PLAYER_3 = {}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AXE_PLAYER_3.GENERIC = "Lucy the Axe"


STRINGS.NAMES.NIGHTSWORD_PLAYER3 = "Dark Sword"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTSWORD_PLAYER3 = {}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTSWORD_PLAYER3.GENERIC = "Dark Sword"


STRINGS.NAMES.LIGHTER_PLAYER_3 = "Lucky Lighter"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LIGHTER_PLAYER_3 = {}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LIGHTER_PLAYER_3.GENERIC = "Lucky Lighter"

STRINGS.NAMES.balloons_empty_player_3 = "Empty Balloons"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BALLOONS_EMPTY = {}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BALLOONS_EMPTY.GENERIC = "Empty Balloons"
---------/////////// PLAYER 3 SPECIAL ITEMS end/////////////-------

TUNING.COOP_OFFEST_X = 100
TUNING.COOP_OFFEST_Y = 50
--TUNING.COOP_CUSTOM_HUD = GetModConfigData("CustomeInvPos")
TUNING.COOP_BADGE_POSITION1 = GetModConfigData("Inv_Position1")
TUNING.COOP_BADGE_POSITION2 = GetModConfigData("Inv_Position2")

TUNING.PLAYER_3_CHARACTER = GetModConfigData("Char Name")
TUNING.PICK_CHAR_IN_WORLD = GetModConfigData("Character")

TUNING.NUMPADCONROLLS =2-- GetModConfigData("NUMPAD")
TUNING.GHOSTPLAYERON = GetModConfigData("Ghost_player")

TUNING.DEFENCEOFF = GetModConfigData("Coop_Defence")

TUNING.CONTROLLER = GetModConfigData("CONTROLLER")


TUNING.COOP_MOD_RESPAWNS = GetModConfigData("Respawns")




AddPrefabPostInit("world", function(inst)
	GLOBAL.assert( GLOBAL.GetPlayer() == nil )
	local player_prefab = GLOBAL.SaveGameIndex:GetSlotCharacter()

	-- Unfortunately, we can't add new postinits by now. So we have to do
	-- it the hard way...

	GLOBAL.TheSim:LoadPrefabs( {player_prefab} )
	local oldfn = GLOBAL.Prefabs[player_prefab].fn
	GLOBAL.Prefabs[player_prefab].fn = function()
		local inst = oldfn()

--//////////////////////////////////////////////////////////////////--
	if TUNING.CONTROLLER == 2 then
		TUNING.NUMPADCONROLLS = 2
		
		
		if	TUNING.PICK_CHAR_IN_WORLD ==1	then	--GetModConfigData("Character")
			TUNING.PLAYER_3_CHARACTER = "wilson"
			print("===DEFAULT 2nd player")
		end
		
		print("===DEFAULT CONTROLLER CONROLS")

	end
--//////////////////////////////////////////////////////////////////--

		inst:AddComponent("playercontroller_spawner")
		inst:AddComponent("p3stats_saver")
		
		
		local function addlife(inst)
			if GLOBAL.GetClock():IsDay() then
				GetPlayer().components.p3stats_saver:RespawnDelta(1,GetPlayer())
			end
		end
		inst:ListenForEvent( "daytime", function() addlife(inst) end , GetWorld())

		return inst
	end
end)


